/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.core.translations;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.impactdev.impactor.api.text.TextProcessor;
import net.impactdev.impactor.api.translations.TranslationManager;
import net.impactdev.impactor.api.translations.repository.TranslationRepository;
import net.impactdev.impactor.api.utility.ExceptionPrinter;
import net.impactdev.impactor.core.plugin.BaseImpactorPlugin;
import net.impactdev.impactor.core.translations.builders.ImpactorTranslationManagerBuilder;
import net.impactdev.impactor.core.translations.components.TranslationSet;
import net.impactdev.impactor.core.translations.repository.ImpactorTranslationRepository;
import net.impactdev.impactor.relocations.com.github.benmanes.caffeine.cache.Cache;
import net.impactdev.impactor.relocations.com.github.benmanes.caffeine.cache.Caffeine;

public class ImpactorTranslationManager
implements TranslationManager {
    private final TranslationRepository repository;
    private final Locale defaultLocale;
    private final Path root;
    private final TextProcessor processor;
    private final Supplier<InputStream> supplier;
    private final Cache<Locale, TranslationSet> translations = Caffeine.newBuilder().build();
    private final Set<Locale> installed = ConcurrentHashMap.newKeySet();

    public ImpactorTranslationManager(ImpactorTranslationManagerBuilder builder) {
        this.repository = builder.repository;
        this.defaultLocale = builder.defaultLocale;
        this.root = builder.path;
        this.processor = builder.processor;
        this.supplier = builder.supplier;
        ((ImpactorTranslationRepository)this.repository).manager(this);
    }

    @Override
    public TranslationRepository repository() {
        return this.repository;
    }

    @Override
    public void reload() {
        this.translations.invalidateAll();
        this.installed.clear();
        this.loadFromFileSystem(this.root.resolve("custom"));
        this.loadFromFileSystem(this.root.resolve("repository"));
        if (this.supplier != null) {
            Gson simple = new GsonBuilder().create();
            JsonObject json = (JsonObject)simple.fromJson((Reader)new InputStreamReader(this.supplier.get()), JsonObject.class);
            try {
                this.translations.put(this.defaultLocale, TranslationSet.fromJson(json));
                this.installed.add(this.defaultLocale);
            }
            catch (Exception e) {
                ExceptionPrinter.print(BaseImpactorPlugin.instance().logger(), e);
            }
        }
    }

    @Override
    public void refresh() {
        this.repository.refresh().whenComplete((result, tracked) -> {
            if (tracked != null) {
                ExceptionPrinter.print(BaseImpactorPlugin.instance().logger(), tracked);
            }
            if (result.booleanValue()) {
                this.reload();
            }
        });
    }

    @Override
    public TextProcessor processor() {
        return this.processor;
    }

    @Override
    public Locale defaultLocale() {
        return this.defaultLocale;
    }

    @Override
    public Set<Locale> installed() {
        return Collections.unmodifiableSet(this.installed);
    }

    @Override
    public Path root() {
        return this.root;
    }

    public TranslationSet fetch(Locale locale) {
        return this.translations.get(locale, key -> Optional.ofNullable(this.translations.getIfPresent(this.defaultLocale())).orElseThrow(() -> new IllegalStateException("Fallback locale had no registration...")));
    }

    @Override
    public void initialize() {
        try {
            Path custom;
            Path repository = this.root.resolve("repository");
            if (Files.notExists(repository, new LinkOption[0])) {
                Files.createDirectories(repository, new FileAttribute[0]);
            }
            if (Files.notExists(custom = this.root.resolve("custom"), new LinkOption[0])) {
                Files.createDirectories(custom, new FileAttribute[0]);
            }
            this.reload();
        }
        catch (Exception exception) {
            ExceptionPrinter.print(BaseImpactorPlugin.instance().logger(), exception);
        }
    }

    private void loadFromFileSystem(Path directory) {
        try (Stream<Path> stream = Files.list(directory);){
            List translations = stream.filter(ImpactorTranslationManager::isConfigurationFile).collect(Collectors.toList());
            for (Path translation : translations) {
                try {
                    Map.Entry<Locale, TranslationSet> result = this.loadTranslationsFromFile(translation);
                    if (!this.installed.add(result.getKey())) continue;
                    this.translations.put(result.getKey(), result.getValue());
                }
                catch (Exception e) {
                    BaseImpactorPlugin.instance().logger().warn("Error loading locale file: " + String.valueOf(translation.getFileName()));
                }
            }
        }
        catch (Exception e) {
            BaseImpactorPlugin.instance().logger().severe("Exception occurred loading translations...");
            ExceptionPrinter.print(BaseImpactorPlugin.instance().logger(), e);
        }
        this.translations.asMap().forEach((locale, config) -> {
            Locale noCountry = new Locale(locale.getLanguage());
            if (!locale.equals(noCountry) && this.installed.add(noCountry)) {
                this.translations.put((Locale)locale, (TranslationSet)config);
            }
        });
    }

    private Map.Entry<Locale, TranslationSet> loadTranslationsFromFile(Path target) throws Exception {
        String name = target.getFileName().toString();
        String localeString = name.substring(0, name.length() - ".conf".length());
        Locale locale = TranslationManager.parseLocale(localeString);
        if (locale == null) {
            throw new IllegalStateException("Unknown locale '" + localeString + "' - skipping registration");
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        JsonObject json = (JsonObject)gson.fromJson((Reader)new FileReader(target.toFile()), JsonObject.class);
        return Maps.immutableEntry((Object)locale, (Object)TranslationSet.fromJson(json));
    }

    public static boolean isConfigurationFile(Path path) {
        return path.getFileName().toString().endsWith(".conf");
    }
}

